/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


var STBModuleTopintro = Object.create(STBModule.prototype);
STBModuleTopintro.name = "ModuleTopintro";

STBModuleTopintro.initAnimation = function() {
	var intro = jQuery('.centered-content').find('.intro:not(.__done)'),
		body  = jQuery('body');

	if (intro.length > 0) {
		intro.each(function () {

			var fadeStart = 0,
				fadeUntil = 350,
				fading = jQuery(this);

			var onScroll = function () {

				if (jQuery("body").hasClass("frozen")) {
					return null;
				}

				var offset = jQuery(document).scrollTop(),
					opacity = 0;

				if (offset <= fadeStart) {
					opacity = 1;
				} else if (offset <= fadeUntil) {
					opacity = 1 - offset / fadeUntil;
				}

				fading.css('opacity', opacity);
			};

			jQuery(window).on('scroll', onScroll);
		});

		intro.addClass("__done");
	}
}

STBModuleTopintro.disable = function() {
	var top = jQuery("body > .topintro");

	if (top.length > 0)	{
		top.remove();
	}
}


STBModuleTopintro.initButtons = function() {
	var intros = jQuery(".topintro:not(.__done), .widget-topintro-content:not(.__done)");

	if (intros.length) {
		intros.each(function() {
			var buttons = jQuery(this).find(".buttons .btn"),
				max = 0;

			if (buttons.length){
				buttons.each(function() {
					max = Math.max(Math.ceil(jQuery(this).outerWidth()) , max);
				});

				buttons.css('width' , max);
			}
		});

		intros.addClass('__done');
	}
}

STBModuleTopintro.headerOverlapTopintro = function() {
	var body	     = jQuery("body"),
		topIntro     = jQuery(".topintro"),
		intro        = topIntro.find(".intro"),
		wrapper      = jQuery(".wrapper"),
		header       = wrapper.find(".header"),
		headerHeight = header.outerHeight();

	if (topIntro.length && body.attr('data-topintro-menu') === 'true') {
		wrapper.css("margin-top", -headerHeight);
	}
}

STBModuleTopintro.introHeight = function() {
	var body	     = jQuery("body"),
		topIntro     = jQuery(".topintro"),
		intro        = topIntro.find(".intro"),
		wrapper      = jQuery(".wrapper"),
		header       = wrapper.find(".header"),
		headerHeight = header.outerHeight(),
		windowHeight = jQuery(window).height();

	if (intro.length && body.attr('data-topintro-menu') === 'true') {
		intro.css("height", windowHeight - headerHeight);
	}
}

STBModuleTopintro.pageHasTopIntro =  function() {
	return (jQuery("body").find(".topintro").length > 0);
}

STBModuleTopintro.runOnReady = function() {
	STBModuleTopintro.initButtons();
	STBModuleTopintro.initAnimation();
	STBModuleTopintro.headerOverlapTopintro();
	STBModuleTopintro.introHeight();
}

STBModuleTopintro.runOnContentUpdate = function() {
	STBModuleTopintro.initButtons();
	STBModuleTopintro.initAnimation();
	STBModuleTopintro.headerOverlapTopintro();
	STBModuleTopintro.introHeight();
}

STBModuleTopintro.runOnResize = function() {

	var body = jQuery("body");	

	if (body.hasClass("device-is-tablet") || body.hasClass("device-is-mobile") ) {
		return true;
	}

	STBModuleTopintro.initButtons();
	STBModuleTopintro.headerOverlapTopintro();
	STBModuleTopintro.introHeight();
}

site.registerModule(STBModuleTopintro);